/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2005 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.IO;
using System.Collections;
using System.Collections.Specialized;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Resources;
using System.Data;
using System.Reflection;

namespace Borland.Data.Web
{

	public enum ImageType
	{
		itNone,
		itJpg,
		itPng,
		itGif,
		itBmp
   }

	/// <summary>
	/// Borland DBWeb Utility Classes
	/// </summary>

#region Consts
  // { Do Not Localize any of these consts}
   public class DBTypes
   {
		public const string sDBWebControl    = "DBWebControl";
		public const string sDBWebDataSource = "DBWebDataSource";
		public const string sDBDataSource    = "DBDataSource";
		public const string sTableName       = "TableName";
		public const string sLookupTableName = "LookupTableName";
		public const string sColumnName      = "ColumnName";
		public const string sAggregateType   = "AggregateType";
   }

   public class DBWebConst
   {
		public const string sCurrentRowIndex = "RowIndex";
		public const string sRowCount = "RowCount";
		public const string sFirstParentRow = "FirstParentRow";
		public const string sParentRow = "ParentRow";
		public const string sLastRow = "LastRow";
		public const string sNextText = "Next";
		public const string sPrevText = "Prev";
		public const string sFirstText = "First";
		public const string sLastText = "Last";
		public const string sDeleteText = "Delete";
		public const string sInsertText = "Insert";
		public const string sApplyText = "ApplyToServer";
		public const string sRefreshText = "RefreshData";
		public const string sUndoText = "Undo";
		public const string sUndoAllText = "UndoAll";
		public const string Splitter = ":";
		public const string sDbxDelta = "DbxDelta";
		public const string sDbxDelete = "dbxDelete";
		public const string sDbxInsert = "dbxInsert";
		public const string sBeginRowCol = ":_:";
		public const string sEndRowCol = "_:_";
		public const string sBeginParentRows = "_pr_";
		public const string sParentRowsAsKeys = "K_";
		public const string sParentRowKeySeparator = "_*_";
		public const string sEndParentRows = "_epr_";
		public const string sRowColSplitter = ",";
		public const string sGridColumnID = ":_ctl";
		public const string sDBWebDataGrid = "DBWebDataGrid";
		public const string sErrorKey = "BorlandDBWebControlError_";
		public const string sDataSource = "DBWebControlDataSource";
		public const string sGridColumnCount = "_GridColumnCount";
		public const string sSetRow = "_SetCurrentRow";
		public const string sCancelChange = "_CancelChange";
		public const string sCancelAll = "_DBWebCancelAll";
		public const string sDeleteRow = "_DeleteRow";
		public const string sLastButtonSelected = "_LastButtonSelected";
		public const string sAutoGenerateColumns = "_AutoGenerateColumns";
		public const string sInvalidBoundColumns = "_InvalidBoundColumns";
		public const string sDBWPostCollection = "_PostCollection_";
		public const string sChangedRow = "_NewRow_";
		public const string sBorlandImageID = "borlandimageid";
		public const string sBorlandImageFile = "BorlandImageFile";
		public const string sLoading = "_LoadingStateChanges";
		public const string sRequestID = "_RequestID";
		public const string sImageIndex = "_ImageIndex";
		public const string sHardDeletes = "_UseHardDelete";
		public const string sApplyDeletes = "_ApplyDeletes";
		public const string sInsertingRow = "_InsertingRow";
		public const string sGridPushButtonCount = "_GridPushButtonCount";
		public const string sErrorState = "_ErrorState";
		public const string sLastKeyAdded = "_LastKey";
		public const string sCacheFile = "Cache File";
		public const string sAggregates = "_Aggs";
		public const string sAggKey = "_AggKey:";
		public const string sAggAvg = "_AggAvg";
		public const string sAggTotal = "_AggTotal";
		public const string sAggMin = "_AggMin";
		public const string sAggMax = "_AggMax";
		public const string sLastUser = "DBWLastUser_";
		public const string sInvalidRow = "_InvRow_";
		public const string sDSControl = "_DSControl_";
	}
#endregion

#region resources
	  public class BdwResources
	{
	  private static ResourceManager m_ResManager = null;

     static BdwResources()
     {
#if STD
		 m_ResManager = new ResourceManager("Borland.Data.Web.BdwResources", typeof(Borland.Data.Web.BdwResources) .Assembly);
#else
		 m_ResManager = new ResourceManager("BdwResources", typeof(Borland.Data.Web.BdwResources) .Assembly);
#endif
     }

     public static String GetString(String Key)
     {
       return m_ResManager.GetString(Key);
     }
   }
#endregion

	[AttributeUsage(AttributeTargets.All)]
	public class LocalizableDescriptionAttribute: DescriptionAttribute
	{
		private bool localized = false;

		public LocalizableDescriptionAttribute(string description): base(description)
		{
		}

		public override string Description
		{
			get
			{
				if (!localized)
				{
						string localizedDescription = BdwResources.GetString(DescriptionValue);
						if (localizedDescription != null)
							DescriptionValue = localizedDescription;
						// if localizedDescription is not found, still use DescriptionValue string.
						localized = true;
				}
				return DescriptionValue;
			}
		}
	}

	[AttributeUsage(AttributeTargets.All)]
	public class LocalizableCategoryAttribute : CategoryAttribute
	{
		private string description;

		public LocalizableCategoryAttribute(string key): base(key)
		{
		}

		protected override string GetLocalizedString(string value)
		{
			if (description == null)
				description = base.GetLocalizedString(value);
			if (description == null)
				description = BdwResources.GetString(value);
			if (description == null)
				description = value;
			return description;
		}
	}

	public sealed class TypeLiterals
	{
		public const string SystemBoolean = "System.Boolean";
		public const string SystemByte = "System.Byte";
		public const string SystemByteArray = "System.Byte[]";
		public const string SystemChar = "System.Char";
		public const string SystemCharArray = "System.Char[]";
		public const string SystemDateTime = "System.DateTime";
		public const string SystemDecimal = "System.Decimal";
		public const string SystemDouble = "System.Double";
		public const string SystemInt16 = "System.Int16";
		public const string SystemInt32 = "System.Int32";
		public const string SystemInt64 = "System.Int64";
		public const string SystemUInt16 = "System.UInt16";
		public const string SystemUInt32 = "System.UInt32";
		public const string SystemUInt64 = "System.UInt64";
		public const string SystemSingle = "System.Single";
		public const string SystemString = "System.String";
		public const string SystemTimeSpan = "System.TimeSpan";
	}


   #region Class and DataSet utils
   public class ClassUtils
   {

      private ClassUtils()
      {
      	/// Private constructor prevents creation of this static class
      }

	  public static bool RefreshRequested(NameValueCollection postCollection, DataSet ds,
				string DataSourceName)
	  {
			if( (postCollection != null) && (postCollection.Count > 0) )
			{
				for( int i = 0; i < ds.Tables.Count; i++ )
				{
					if(ClassUtils.PostCollectionHasValue(postCollection, ds.Tables[i].TableName, DBWebConst.sRefreshText, DataSourceName) )
						return true;
				}
			}
			return false;
	  }
	  public static bool RefreshRequested(Page page, DataSet ds, string DataSourceName)
	  {
			if( ClassUtils.IsDesignTime(page) )
				return false;
			NameValueCollection postCollection = page.Session[DataSourceName + DBWebConst.sDBWPostCollection] as NameValueCollection;
			return RefreshRequested(postCollection, ds, DataSourceName);
	  }

		protected static bool IsNumeric(DataColumn column)

      {

         return column.DataType == Type.GetType("System.Int32") ||

                column.DataType == Type.GetType("System.Int16") ||

                column.DataType == Type.GetType("System.Int64") ||

                column.DataType == Type.GetType("System.UInt16") ||

                column.DataType == Type.GetType("System.UInt32") ||

                column.DataType == Type.GetType("System.UInt64") ||

                column.DataType == Type.GetType("System.Single") ||

                column.DataType == Type.GetType("System.Double") ||

                column.DataType == Type.GetType("System.Byte") ||

                column.DataType == Type.GetType("System.Decimal");

      }


      public static bool CheckColumnTypeForAggregate(DataColumn column, AggType aggType)

      {

         bool value;

         switch(aggType)

         {

            case AggType.aggCount:

               value = true;

               break;

            case AggType.aggSum:

            case AggType.aggAvg:

               value = IsNumeric(column);

               break;

			case AggType.aggMin:

            case AggType.aggMax:

               value = column.DataType == Type.GetType("System.String") ||

                        column.DataType == Type.GetType("System.Char") ||

                        column.DataType == Type.GetType("System.DateTime") ||

                        IsNumeric(column);

               break;

            default:

               value = false;

               break;

         }

         return value;

      }


	  public static bool Excluded(ArrayList ExcludeList, string typeName)

      {
         for( int i = 0; i < ExcludeList.Count; i++ )
            if(ExcludeList[i].ToString() == typeName )
               return true;
         return false;
      }

      public static bool IsValidType(ArrayList LimitType, string sType)

      {
         if( LimitType == null || LimitType.Count == 0 )
            return true;
         for( int i = 0; i < LimitType.Count; i++ )
            if( LimitType[i].ToString() == sType )
               return true;
         return false;
      }

			  /* retrieve Next Insert Key from changes */
	  public static string NextInsertKey(string PageName, NameValueCollection changes, string tableName)
	  {
		for( int i = 0; i < changes.Count; i++ )
		{
			string Key = changes.GetKey(i);
			if( Key.StartsWith(DBWebConst.sDbxDelta + PageName + tableName + DBWebConst.Splitter) &&
					( Key.IndexOf(DBWebConst.sDbxInsert) > 0 ) )
			{
				return Key;
			}
		}
		return null;
	  }

	  public static bool IsInsertKey(string sKey, string PageName, String tableName)
	  {
		return sKey.StartsWith(DBWebConst.sDbxDelta + PageName + tableName + DBWebConst.Splitter) &&
					( sKey.IndexOf(DBWebConst.sDbxInsert) > 0 );
	  }

	  /* retrieve Next Delete Key from changes */
	  public static string NextDeleteKey(string PageName, NameValueCollection changes, string tableName)
	  {
		for( int i = 0; i < changes.Count; i++ )
		{
			string Key = changes.GetKey(i);
			if( Key.StartsWith(DBWebConst.sDbxDelta + PageName + tableName + DBWebConst.Splitter) &&
					( Key.IndexOf(DBWebConst.sDbxDelete) > 0 ) )
			{
				return Key;
			}
		}
		return null;
	  }

	  public static bool IsDeleteKey(string sKey, string PageName, String tableName)
	  {
		return sKey.StartsWith(DBWebConst.sDbxDelta + PageName + tableName + DBWebConst.Splitter) &&
					( sKey.IndexOf(DBWebConst.sDbxDelete) > 0 );

	  }

	  /* all inserts have now been handled and removed */
	  public static string NextUpdateKey(string PageName, NameValueCollection changes, string TableName)
	  {
		/* start with last Key: if a column value has been changed twice,
		   it will only be updated with the last value */
		string Key;
		for( int i = changes.Count -1; i >= 0; i-- )
		{
			Key = changes.Keys[i];
			if( Key.StartsWith(DBWebConst.sDbxDelta + PageName + TableName + DBWebConst.Splitter) &&
					Key.IndexOf(DBWebConst.sDbxDelete) < 0 )
				return Key;
		}
		return null;
	  }

	  public static bool IsUpdateKey(string sKey, string PageName, String tableName)
	  {
		 return sKey.StartsWith(DBWebConst.sDbxDelta + PageName + tableName + DBWebConst.Splitter) &&
					( sKey.IndexOf(DBWebConst.sDbxDelete) < 1 ) &&
					( sKey.IndexOf(DBWebConst.sDbxInsert) < 1 );
	  }


	  public static object CopyDataSource(object o)

	  {

      	if( o is DataSet )

        	   return (o as DataSet).Copy();

		 else if( o is DataTable )

         {

            if( (o as DataTable).DataSet != null )

            {

               DataSet ds = (o as DataTable).DataSet.Copy();

               return ds.Tables[(o as DataTable).TableName];

            }

         }

      	else if( o is DataView )

      	{

            if( ((o as DataView).Table != null) && ((o as DataView).Table.DataSet != null) )

            {

         	   DataSet ds = (o as DataView).Table.DataSet.Copy();

			   DataView view = new DataView();

         	   view.Table = ds.Tables[(o as DataView).Table.TableName];

      	      view.RowFilter = (o as DataView).RowFilter;

      	      view.Sort = (o as DataView).Sort;

      	      return view;

            }

         }

         return null;

      }


      public static bool IsNumber(string value)
		{
			double d;
			try
			{
				d = Convert.ToDouble(value);
				return true;
			}
			catch(Exception ex)
			{
				return false;
			}
		}

		public static Object ObjectFromString(Type type, string value)
		{
			if( type == Type.GetType(TypeLiterals.SystemString) )
				return value;
			if( type == Type.GetType(TypeLiterals.SystemDouble) )
				return Convert.ToDouble(value);
			if( type == Type.GetType(TypeLiterals.SystemBoolean) )
				return ConvertToBoolean(value);
			if( type == Type.GetType(TypeLiterals.SystemInt16) )
				return Convert.ToInt16(value);
			if( type == Type.GetType(TypeLiterals.SystemInt32) )
				return Convert.ToInt32(value);
			if( type == Type.GetType(TypeLiterals.SystemInt64) )
				return Convert.ToInt64(value);
			if( type == Type.GetType(TypeLiterals.SystemDecimal) )
				return Convert.ToDecimal(value);
			if( type == Type.GetType(TypeLiterals.SystemDateTime) )
				return Convert.ToDateTime(value);
			if( type == Type.GetType(TypeLiterals.SystemUInt16) )
				return Convert.ToUInt16(value);
			if( type == Type.GetType(TypeLiterals.SystemUInt32) )
				return Convert.ToUInt32(value);
			if( type == Type.GetType(TypeLiterals.SystemUInt64) )
				return Convert.ToUInt64(value);
			if( type == Type.GetType(TypeLiterals.SystemChar) )
				return Convert.ToChar(value);
			if( type == Type.GetType(TypeLiterals.SystemByte) )
				return Convert.ToByte(value);
			return value;
		}


 
      public static bool IsEmpty(string Setting)
      {
      	return (Setting == null || Setting == "");
	  }

	  protected static bool BooleanCompare(string s1, string s2)
	  {
		if( s1 == "" )
			return s2 == "";
		string sTrue = BdwResources.GetString("TrueValues");
		if( sTrue.IndexOf(s1.ToLower()) >= 0 )
			return sTrue.IndexOf(s2.ToLower()) >= 0;  
		else
			return (s2 != "") && sTrue.IndexOf(s2.ToLower()) < 0;
	  }

	  protected static bool ConvertToBoolean(string s)
	  {  // value 'on' throws an exception from Convert.ToBoolean(s)
		  if( ClassUtils.IsEmpty(s) )
			  return false;
		  string sTrue = BdwResources.GetString("TrueValues");
		  return sTrue.IndexOf(s.ToLower()) >= 0;
	  }

	  public static bool CompareObjects(Object o1, Object o2, string dataType)
	  {
		bool bCompare = false;
		if( o1 == null || (o1 is DBNull) )
			bCompare = (o2 == null) || (o2 is DBNull);
		else if( (o2 != null) && (!(o2 is DBNull)) )
		{
			if( dataType == "System.Boolean" )
				bCompare = BooleanCompare(o1.ToString(), o2.ToString() );
			else
				bCompare = (o1.ToString() == o2.ToString());
		}
		// else bCompare remains false
		return bCompare;
	  }

	  public static bool IsSameRow(DataRow row, DataColumnCollection columns, ArrayList RowValues)
	  {
		 for( int i = 0; i < columns.Count; i++ )
		 {
			string dataType = columns[i].DataType.ToString();
			Object o = row[columns[i].Ordinal];
			if( !CompareObjects(o, RowValues[i], dataType ) )
			   return false;
		 }
		 return true;
      }

      public static bool IsSameRow(DataRow row, DataColumnCollection columns, ArrayList KeyNames, ArrayList RowValues, bool CaseInsensitive, bool PartialKey)
      {
         for( int i = 0; i < KeyNames.Count; i++ )
         {
            DataColumn column = columns[(KeyNames[i]).ToString()];
            string dataType = column.DataType.ToString();
            Object o1 = row[column.Ordinal];
            Object o2 = RowValues[i];
            if( column.DataType == System.Type.GetType("System.String")
                && (o1 != null) && (o2 != null) )
				{
               if( CaseInsensitive )
               {
				  o1 = o1.ToString().ToLower();
                  o2 = o2.ToString().ToLower();
               }
               if( PartialKey )
                  o1 = o1.ToString().Substring(0, o2.ToString().Length);
            }
            if( !CompareObjects(o1, o2, dataType ) )
               return false;
         }
         return true;
         }

	  public static void SetFontProps(WebControl target, WebControl source)
      {
         target.Font.CopyFrom(source.Font);
      }
   	public static void SetControlProps(WebControl target, WebControl source)
      {
         target.BorderStyle = source.BorderStyle;
         target.BackColor = source.BackColor;
         target.BorderColor = source.BorderColor;
         target.BorderWidth = source.BorderWidth;
		 target.ForeColor = source.ForeColor;
		 SetFontProps(target, source);
	  }
      public static void TruncatePanelWidth(Panel APanel, double iExtraPanelPixels)
	  {
         if( iExtraPanelPixels >= 0 )
		 {
			APanel.Width = new Unit(APanel.Width.Value - iExtraPanelPixels);
         }
	  }

	  public static bool OutputErrors(Page page, HtmlTextWriter output, IDBWebDataLink IDataLink)
	  {
		 string warningHtml = null;
		 string errorHtml = null;
		 bool error = false;
		 if( IDataLink.DBDataSource != null )
		 {
			if((IDataLink.DBDataSource as IPageStateManager).GetErrors(page).Count > 0 )
			{
				if( (IDataLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logWithErrorEvent )
				{
					errorHtml = IDataLink.DBDataSource.GetErrorHtml(page, IDataLink.TableName);
					output.Write(errorHtml);
				}
				error = true;
			}
			if((IDataLink.DBDataSource as IPageStateManager).GetWarnings(page).Count > 0 )
			{
				if( (IDataLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logWithErrorEvent )
				{
					warningHtml = IDataLink.DBDataSource.GetWarningHtml(page, IDataLink.TableName);
					output.Write(warningHtml);
				}
			}
			if( error )
				(IDataLink.DBDataSource as IPageStateManager).DoOnError(page);
		 }
		 return error;
	  }

	  public static string GetInternalError(Page page, IDBWebDataLink IDataLink, Exception ex,
								string ModuleName)
	  {
       if( IDataLink.DBDataSource is IDBPostStateManager)
		   (IDataLink.DBDataSource as IDBPostStateManager).SetCurrentRow(page, IDataLink.TableName, 0);
		 StringWriter sw = new StringWriter();
		 HtmlTextWriter tw = new HtmlTextWriter(sw);
		 tw.Write("<table width='100%' border=4><tr><td>");
		 tw.Write(BdwResources.GetString("InternalError") + " " + ModuleName);
		 tw.Write("</td></tr><tr><td>");
		 tw.Write(ex.Message);
		 tw.Write("</td></tr></table><p>");
		 return sw.ToString();
	  }

	  public static string GetPageName(Page page)
	  {
		Type t = page.GetType();
		FieldInfo[] fields = t.GetFields(BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic);
		if( fields != null )
		{
			foreach( FieldInfo field in fields )
			{
				if(  String.Compare(field.FieldType.ToString(), "System.Web.UI.HtmlControls.HtmlForm") == 0 )
					return field.ReflectedType.BaseType.FullName + "_";
			}
		}
		return null;
	  }

	  // if TableName = "", returns all changes
	  public static NameValueCollection ChangesForTable(Page page, string TableName)
	  {
		string PageName = ClassUtils.GetPageName(page);
		NameValueCollection changes = new NameValueCollection();
		string Key, Value;
		for( int i = 0; i < page.Session.Count; i++ )
		{
			Key = page.Session.Keys[i];
			if( Key.StartsWith(DBWebConst.sDbxDelta + PageName + TableName) )
			{
				Value = Convert.ToString(page.Session[i]);
				changes.Add(Key, Value);
			}
		}
		return changes;
	  }

	  public static string OKButtonString()
	  {
		  StringWriter sw = new StringWriter();
		  HtmlTextWriter output = new HtmlTextWriter(sw);
		  OutputOKButton(output);
		  return sw.ToString();
	  }

	  public static void OutputOKButton(HtmlTextWriter output)
	  {
		 Button button = new Button();
		 button.Text =  BdwResources.GetString("OK");
		 button.BorderWidth = new Unit(4);
		 button.Width = new Unit(48);
         button.Height = new Unit(32);
         button.ID = "OK";
         output.Write("<p><center>");
         button.RenderControl(output);
         output.Write("<p></center>");
      }

      public static bool SameValue(string v1, string v2)
      {
      	if( v1 == null && v2 == null )
         	return true;
         else if( v1 == null || v2 == null )
         	return false;
         else return (v1 == v2);
      }

       #region Base Property Setting
		//	in cases where a derived control renders multiple ASP controls, the
      // class will not set the WebControl property.  In this case
      // appearance and behavior properties can be set on a control by
      // control basis.

      public static void SetAppearanceProperties( WebControl control, WebControl source )
      {
      	SetOuterAppearanceProperties(control, source);
         SetInnerAppearanceProperties(control, source);
         SetSizeProperties(control, source);
      }

      public static void SetSizeProperties( WebControl control, WebControl source )
      {
      	control.Width = source.Width;
      	control.Height = source.Height;
      }

      public static void SetOuterAppearanceProperties( WebControl control, WebControl source  )
      {
      	control.BorderColor = source.BorderColor;
      	control.BorderStyle = source.BorderStyle;
      	control.BorderWidth = source.BorderWidth;
      }
      public static void SetInnerAppearanceProperties( WebControl control, WebControl source  )
      {
      	control.ForeColor = source.ForeColor;
         control.BackColor = source.BackColor;
         control.Font.CopyFrom(source.Font);
      }
	  public static void SetBehaviorProperties( WebControl control, WebControl source  )
      {
      	control.Visible = source.Visible;
      	control.Enabled = source.Enabled;
      	control.AccessKey = source.AccessKey;
      	control.TabIndex = source.TabIndex;
         control.ToolTip = source.ToolTip;
      	control.EnableViewState = source.EnableViewState;
      }
      #endregion Base Property Setting

	  public static ArrayList ArrayListFromIntArray(int [] intArray)
	  {
		ArrayList arrayList = new ArrayList();
		for( int i = 0; i < intArray.Length; i++ )
			arrayList.Add(intArray[i]);
		return arrayList;
	  }

      public static bool IsDesignTime(Page page)
      {
		 if( page == null )
			return true;
		 else if( page.Site != null )
			return page.Site.DesignMode;
		 return false;
	  }
	  #region KeyManagement
	  // the KeyString contains the current of any parent tables, the row and col of
	  // the current table, all preceded by sDbxDelta.  It is stored with a new value
	  // in Page.Application to maintain changes associated with a particular session.
	  // After ApplyChanges is successfully called these changes are removed.
	  // Undo removes the last change, UndoAll removes all of them.
	  public static string GetStartKeyName( string sKeyType, string sTableName, string sKeyOrRowValue, int iCol)
	  {
			return sKeyType + sTableName +
						DBWebConst.sBeginRowCol +
						sKeyOrRowValue +
						DBWebConst.sRowColSplitter +
						Convert.ToString(iCol) +
						DBWebConst.sBeginParentRows;
	  }

	  public static string GenKeyForAggregate( string PageName, string TableName, string ColumnName,
						bool ignoreNulls, string sAggType)
	 {
		 string sKey  = DBWebConst.sAggregates + PageName + TableName + DBWebConst.Splitter + ColumnName +
                DBWebConst.Splitter + sAggType;
         if( ignoreNulls )
            sKey = sKey + "_NoNulls";
         else
            sKey = sKey + "_Nulls";
         return sKey;
	  }

	  public static string GenKeyForChangedColumn(string PageName, string sTableName, int iCol )
	  {
			return PageName + sTableName + "_" + Convert.ToString(iCol);
	  }

	  public static string GenKeyForForeignKeyColumn(string PageName, string TableName, string ColumnName)
	  {
			return PageName + "_DBWForeignKey_" + TableName + ColumnName;
	  }

	  public static string GenKeyName(string PageName, string sKeyType, string sTableName, int iRow, int iCol, string oldValue, ArrayList ParentRows)
	  {
		  return GenKeyName(PageName, sKeyType, sTableName, Convert.ToString(iRow), iCol, oldValue, ParentRows, false);
	  }

	  public static string GenKeyName(string PageName, string KeyType, string TableName, string KeyOrRowValue, int iCol, string oldValue, ArrayList ParentRows, bool UseParentKeys)
	  {
		string KeyName;
		KeyName = GetStartKeyName(KeyType, PageName + TableName, KeyOrRowValue, iCol );
		if( UseParentKeys )
			KeyName = KeyName + DBWebConst.sParentRowsAsKeys;
		for( int i = 0; i < ParentRows.Count; i++ )
			KeyName = KeyName + Convert.ToString(ParentRows[i]) + DBWebConst.sRowColSplitter;
		if( oldValue != null )
			return KeyName + DBWebConst.sEndParentRows + oldValue;
		return KeyName + DBWebConst.sEndParentRows;
	  }

	  public static string GenKeyName(string PageName, string sKeyType, string sTableName, int iRow, int iCol, string oldValue, int[] ParentRows)
	  {
		 ArrayList parentRows = ArrayListFromIntArray(ParentRows);
		 return GenKeyName(PageName, sKeyType, sTableName, iRow, iCol, oldValue, parentRows);
	  }

	  // For performance, assume valid keys
	  public static bool DoKeysMatch(string sKey1, string sKey2)
	  {
		 string s1 = sKey1.Substring(0, sKey1.IndexOf(DBWebConst.sEndParentRows) -1);
		 string s2 = sKey2.Substring(0, sKey2.IndexOf(DBWebConst.sEndParentRows) -1);
		 return s1 == s2;
	  }

	  private static ArrayList AddParentRows(string sTemp)
	  {
		 ArrayList Result = new ArrayList();
		 int iSplitPos = sTemp.IndexOf(DBWebConst.sRowColSplitter);
		 while( iSplitPos > 0 )
		 {
			string sRow = sTemp.Substring(0, iSplitPos);
			Result.Add(Convert.ToInt32(sRow));
			sTemp = sTemp.Substring(iSplitPos + 1);
			iSplitPos = sTemp.IndexOf(DBWebConst.sRowColSplitter);
			if( sTemp.StartsWith(DBWebConst.sEndParentRows) )
				break;
		 }
		 return Result;
	  }

	  // Given a specific Key from Page.Application.GetKey(index), extract
	  // the current rows of any parent tables, and the row and col of the current
	  // table so we know into which row/col to insert the changed value.
	  // the return value is the array of Current Rows for all tables in the
	  // dataset, so we know for which parent row a child row is referring
	  public static ArrayList GetRowColFromKey(string sKey, String PageName, out string TableName, out int iRow, out int iCol, out string sOldValue)
	  {
		 int iRowColStart = sKey.IndexOf(DBWebConst.sBeginRowCol);
		 int iDDL = DBWebConst.sDbxDelta.Length + PageName.Length;
		 TableName = sKey.Substring(iDDL, iRowColStart - iDDL);
		 iRowColStart += DBWebConst.sBeginRowCol.Length;
		 string sTemp = sKey.Substring(iRowColStart);
		 int iStartParentRows = sTemp.IndexOf(DBWebConst.sBeginParentRows);
		 int iSplitPos = sTemp.IndexOf(DBWebConst.sRowColSplitter);
		 iRow = Convert.ToInt32(sTemp.Substring(0, iSplitPos));
		 iCol = Convert.ToInt32(sTemp.Substring(iSplitPos+1,
										iStartParentRows - (iSplitPos+1)));
		 sTemp = sTemp.Substring(iStartParentRows + DBWebConst.sBeginParentRows.Length);
		 if( sTemp.Substring(0, DBWebConst.sParentRowKeySeparator.Length ) == DBWebConst.sParentRowKeySeparator )
			sTemp = sTemp.Substring(2);
		 ArrayList Result = AddParentRows(sTemp);
		 int iEndParentRow = sKey.IndexOf(DBWebConst.sEndParentRows);
		 if( iEndParentRow + 1 < sKey.Length )
			sOldValue = sKey.Substring(iEndParentRow + DBWebConst.sEndParentRows.Length);
		 else
         	sOldValue = null;
         return Result;
	  }
	  #endregion KeyManagement

	  protected static object GetLookupTextColumnValue(Object o, Object oTV, IDBWebColumnLink link, IDBWebLookupColumnLink ILink)
	  {
		DataTable table;
		if( oTV is DataTable )
			table = (oTV as DataTable);
		else
			table = (oTV as DataView).Table;
		string dataType = table.Columns[ILink.DataValueField].DataType.ToString();
		string columnName = ILink.DataValueField;
		if( ClassUtils.IsEmpty(columnName) )
			columnName = ILink.DataTextField;
		for( int i = 0; i < table.Rows.Count; i++ )
		{
			if( CompareObjects(table.Rows[i][columnName], o, dataType) )
			{
				return table.Rows[i][ILink.DataTextField];
			}
		}
    	return o;
      }
	  public static string BindLookupControl(Page page, DBWebLookupColumnLink link, ListControl control)
	  {
		 string CurrentValue = null;
		 if( link == null )
			return null;
		 IDBWebLookupColumnLink ILink = (link as IDBWebLookupColumnLink);
		 IDBDataSource dataSource = ILink.DBDataSource;
		 if( link.IsDataBound )
		 {
			Object table = dataSource.GetTableOrView(page, ILink.LookupTableName);
			Object targetTable = dataSource.GetTableOrView(page, ILink.TableName);
			control.DataSource = table;
			if( ClassUtils.IsEmpty(control.DataValueField) )
				control.DataValueField = control.DataTextField;
			if( !ClassUtils.IsEmpty(ILink.ColumnName ) )
			{
				object o = (link as IDBWebColumnLink).DBDataSource.GetColumnValue(page,
								(link as IDBWebColumnLink).TableName,
								(link as IDBWebColumnLink).ColumnName);
				if( String.Compare(ILink.DataValueField, ILink.DataTextField) != 0 )
				{
                	o = GetLookupTextColumnValue(o, table, link as IDBWebColumnLink, ILink);
				}
			   if( o != null )
				  CurrentValue = Convert.ToString(o);
			}
		 }
		 return CurrentValue;
	  }

	  public static int CurrentLookupIndex(ListControl control, string CurrentValue)
	  {
		ListItem item = control.Items.FindByText(CurrentValue);
			return control.Items.IndexOf(item);
		}

		public static bool PostCollectionHasValue(NameValueCollection postCollection,
									string DataSourceName, string TableName, string value)
		{
			if( postCollection[DataSourceName + TableName + DBWebConst.Splitter + value] != null ||
					postCollection[DataSourceName + TableName + DBWebConst.Splitter + value + ".x"] != null )
				return true;
			return false;
		}

		public static bool PostCollectionHasValue(NameValueCollection postCollection,
														string TableName, string value)
		{
			if( postCollection[TableName + DBWebConst.Splitter + value] != null ||
					postCollection[TableName + DBWebConst.Splitter + value + ".x"] != null )
				return true;
			return false;
		}

		  // if the same row/col for the same table has been changed twice,
		// only update once.
		public static bool CheckValuesSet(string sKey, ArrayList ColumnsSet)
		{
			for( int i = 0; i < ColumnsSet.Count; i++ )
			{
				if( ClassUtils.DoKeysMatch(sKey, ColumnsSet[i].ToString() ) )
					return true;
			}
			return false;
		}

		public static string GetFullVirtualDirectory(string VirtualPathName)
		{
			const string sHTTP = "http://";
			return sHTTP + System.Environment.MachineName + "/" + VirtualPathName + "/";
		}

		public static void AddStyleToWebControl(WebControl control, CssStyleCollection Style)
		{
			IEnumerator keys = Style.Keys.GetEnumerator();
			while( keys.MoveNext() )
			{
				string key = Convert.ToString(keys.Current);
				string value = Convert.ToString(Style[key]);
				control.Style.Add(key, value);
         }
      }

      public static string GetChangesFileName(string fileName)
      {
         int DotPos = fileName.IndexOf('.');
         if( DotPos == 0 )
            return fileName + ".chngs_.xml";
         else  // { do not localize "_chngs" }
            return fileName.Substring(0, DotPos) + "_chngs_" +
                  fileName.Substring(DotPos);
      }




   }
   #endregion


	#region DesignerUtil Class (DU)
    /// <summary>
    /// General purpose designer utility routines, lifted from BdpDesigners
    /// </summary>
    public class DU : System.Object
    {
        private DU()
        {
            /// Private constructor prevents creation of this static class
        }


        #region Component & Property Routines

        /// <summary>
        /// Returns true of the value is contained in the collection
        /// </summary>
        public static bool CollectionContains(IEnumerable collection, object value)
        {
            foreach (object obj in collection)
                if (obj == value)
                    return true;
            return false;
        }

		/// <summary>
		/// Returns an array of components
		/// </summary>
        public static IComponent[] GetComponents(IEnumerable collection, Type componentType)
        {
            ArrayList componentArray = new ArrayList();
            foreach (IComponent component in collection)
                if (componentType.IsInstanceOfType(component))
                    componentArray.Add(component);
            return (IComponent[])componentArray.ToArray();
        }

        /// <summary>
        /// Returns an array of components
        /// </summary>
        public static object[] GetComponentNames(IEnumerable collection, Type componentType, bool sorted)
        {
            ArrayList componentNames = new ArrayList();
            foreach (IComponent component in collection)
                if (componentType.IsInstanceOfType(component))
                    componentNames.Add(component.Site.Name);
            if (sorted)
                componentNames.Sort();
            return componentNames.ToArray();
        }

        /// <summary>
        /// Simple helper routine to get a property value
        /// </summary>
        public static object GetPropertyValue(object instance, string propertyName)
		  {
				if( instance == null || TypeDescriptor.GetProperties(instance) == null || TypeDescriptor.GetProperties(instance)[propertyName] == null )
					return null;
				return TypeDescriptor.GetProperties(instance)[propertyName].GetValue(instance);
        }

        /// <summary>
        /// Simple helper routine to set a property value
		/// </summary>
        public static void SetPropertyValue(object instance, string propertyName, object value)
        {
        		TypeDescriptor.GetProperties(instance)[propertyName].SetValue(instance, value);
        }

        public static PropertyDescriptorCollection GetProperties(object instance)
        {
            return TypeDescriptor.GetProperties(instance);
		  }
		  public static string GetComponentName(Object o)
		  {
				return TypeDescriptor.GetComponentName(o);
		  }
        #endregion Component & Property Routines

    }
	#endregion DesignerUtil Class (DU)


   #region Debug

   public class Debug

   {   // quick and dirty debugging when client is remote
   	public static void LogString(Page page, string s)
      {
      	string fileName;
         if( !ClassUtils.IsDesignTime(page) )
         	fileName = page.Request.PhysicalApplicationPath + "debug.log";
         else
         	fileName = "c:\\debug.log";
      	LogString(s, fileName, false);
      }

      public static int Inspect(Object o)
      {
      	if( o is DataView )
         {
         	int value = (o as DataView).Count;
            if( value != (o as DataView).Table.Rows.Count )
            	value = (o as DataView).Table.Rows.Count;
            return value;
         }
      	else if( o is DataTable )
         {
         	int value = (o as DataTable).Rows.Count;
            return value;
         }
         else if( o is DataSet )
         {
         	DataSet ds = o as DataSet;
            int value = -1;
			if( ds.Tables.Count > 0 )
				value = (o as DataSet).Tables[0].Rows.Count;
            return value;
         }


         return -1;
      }
      
      public static void LogString(string s, string FileName)
      {
      	LogString(s, FileName, false);
      }
      
      public static void LogString(string s, string FileName, bool CreateNew)
      {
         StreamWriter sw;
      	if(CreateNew && File.Exists(FileName))
         	File.Delete(FileName);
         sw = File.AppendText(FileName);
         try
         {
         	sw.WriteLine(s);
         }
         finally
         {
            sw.Close();
         }
      }
   }
   #endregion

}
